﻿########## 初期設定 ##########

#LTEルーター番号（数字3桁）の入力を受ける
$ROUTERID = Read-Host -prompt "LETルータ番号を入力してください。LTEルータ番号は3桁の半角数字です。（ex. 101、102など）"

if($ROUTERID -match "^\d{3}$"){
    Write-Host "TESTCENTER-${ROUTERID}の設定をします。"
}else{
    Write-Host "LTEルータ番号が正しくありません。LTEルータ番号はLTEルータ本体に貼られている３桁の数字です。（ex.101,102など）。最初からやり直してください。"
    pause
    exit
}

########## 既存SSID削除 ##########

#現在のSSIDの設定を表示
netsh wlan show profile
#現在設定されているSSIDを削除
netsh wlan delete profile name=*
#SSIDを再表示
netsh wlan show profile

########## SSID登録処理 ##########

$SSID = "TESTCENTER-${ROUTERID}"

#環境変数の設定
$SSIDname = "${SSID}"      #SSIDの名前
$nonBroadcast = "true"       
$ConnectionType = "ESS"
$ConnectionMode = "auto"     #[auto] or [manual] 
$authentication = "WPA2PSK"  #[open] or [shared] or [WPA] or [WPA2] or [WPAPSK] or [WPA2PSK]
$encryption = "AES"          #[none] or [WEP] or [TKIP] or [AES]
$useOneX = "false"           #[true] or [false] 
$keyType = "passPhrase"      #[networkKey] or [passPhrase] 基本[passPhrase]
$keyMaterial = "edifjd12"    #SSIDのパスワード
$SSIDHEX = $null


#スクリプトのパス取得
$ScriptFullPath = $MyInvocation.MyCommand.Path
#XMLファイルのパス取得
$XMLPath = $PSScriptRoot + "\WiFi-SSIDProfile.xml"

$Array=$SSIDname[0..$SSIDname.Length]

#$Arrayの要素を1つずつ16進数のASCIIコードに変更し、文字列結合 
for($i = 0; $i -lt $Array.Count; $i++){
    #Write-Host ('$Array[' + $i + ']:' + $Array[$i])
    $a = [byte][char]$Array[$i]
    $HEX = $a.ToString("X2")
    #Write-Host ('$HEX:' + $HEX)
    $SSIDHEX += [string]$HEX
    #Write-Host ('$SSIDHEX:' + $SSIDHEX)
} 


$XMLContents = @"
<?xml version="1.0"?>
<WLANProfile xmlns="http://www.microsoft.com/networking/WLAN/profile/v1">
    <name>$SSIDname</name>
    <SSIDConfig>
        <SSID>
            <hex>$SSIDHEX</hex>
            <name>$SSIDname</name>
        </SSID>
        <nonBroadcast>$nonBroadcast</nonBroadcast>
    </SSIDConfig>
    <connectionType>$ConnectionType</connectionType>
    <connectionMode>$ConnectionMode</connectionMode>
    <MSM>
        <security>
            <authEncryption>
                <authentication>$authentication</authentication>
                <encryption>$encryption</encryption>
                <useOneX>$useOneX</useOneX>
            </authEncryption>
            <sharedKey>
                <keyType>$keyType</keyType>
                <protected>false</protected>
                <keyMaterial>$keyMaterial</keyMaterial>
            </sharedKey>
        </security>
    </MSM>
    <MacRandomization xmlns="http://www.microsoft.com/networking/WLAN/profile/v3">
        <enableRandomization>false</enableRandomization>
    </MacRandomization>
</WLANProfile>


"@

#スクリプトが置かれているフォルダにXMLファイル作成
$xmlDoc = [xml]$XMLContents
$xmlDoc.Save($XMLPath)
Write-Host $XMLPath

#WiFiプロファイルの追加
netsh wlan add profile filename="$XMLPath" user=all

#XMLファイルの削除
Remove-Item -Path $XMLPath -Force

Write-Host "SSID登録完了しました "

Write-Host "30秒待ちます"
sleep -s 30

########## SSID接続処理 ##########

#設定したSSIDプロファイルに接続
netsh wlan connect name="${SSID}"

#20秒待つ
Write-Host "30秒待ちます"
sleep -s 30

########## インターネット接続確認処理 ##########

# pingをwww.google.comに飛ばして応答を確認
$pingAlive = @(Test-Connection -ComputerName www.google.com -Quiet)
if($pingAlive -eq $True){
    Write-Host "www.google.comへのpingでの接続が確認できました。"
} else {
    Write-Host "www.google.comへのpingでの接続が失敗しました。インターネット接続を手動で確認して、必要であればやり直してください。"
}
pause